/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.creeperoverhaul;

import com.google.common.base.Preconditions;
import java.util.Random;
import java.util.function.Predicate;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.biome.v1.ModificationPhase;
import net.fabricmc.fabric.api.client.itemgroup.FabricItemGroupBuilder;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.mixin.object.builder.SpawnRestrictionAccessor;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_1588;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2397;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import software.bernie.example.GeckoLibMod;
import software.bernie.geckolib3.GeckoLib;
import tech.thatgravyboat.creeperoverhaul.common.Events;
import tech.thatgravyboat.creeperoverhaul.common.entity.CreeperTypes;
import tech.thatgravyboat.creeperoverhaul.common.entity.base.BaseCreeper;
import tech.thatgravyboat.creeperoverhaul.common.registry.ModAttributes;
import tech.thatgravyboat.creeperoverhaul.common.registry.ModBlocks;
import tech.thatgravyboat.creeperoverhaul.common.registry.ModEntities;
import tech.thatgravyboat.creeperoverhaul.common.registry.ModItems;

public class Creepers
implements ModInitializer {
    public static final String MODID = "creeperoverhaul";
    public static final Events EVENT = Events.getCurrentEvent();
    public static final class_1761 TAB = FabricItemGroupBuilder.build((class_2960)new class_2960("creeperoverhaul", "item_group"), () -> new class_1799((class_1935)ModItems.JUNGLE_SPAWN_EGG));

    public void onInitialize() {
        GeckoLibMod.DISABLE_IN_DEV = true;
        GeckoLib.initialize();
        ModBlocks.register();
        ModEntities.register();
        ModItems.reigster();
        ModAttributes.register();
        this.addAttributes();
        this.addCreepers();
        this.removeCreepers();
        this.addSpawnRules();
    }

    public void addAttributes() {
        FabricDefaultAttributeRegistry.register(ModEntities.JUNGLE_CREEPER, (class_5132.class_5133)CreeperTypes.JUNGLE.attributes());
        FabricDefaultAttributeRegistry.register(ModEntities.BAMBOO_CREEPER, (class_5132.class_5133)CreeperTypes.BAMBOO.attributes());
        FabricDefaultAttributeRegistry.register(ModEntities.DESERT_CREEPER, (class_5132.class_5133)CreeperTypes.DESERT.attributes());
        FabricDefaultAttributeRegistry.register(ModEntities.BADLANDS_CREEPER, (class_5132.class_5133)CreeperTypes.BADLANDS.attributes());
        FabricDefaultAttributeRegistry.register(ModEntities.HILLS_CREEPER, (class_5132.class_5133)CreeperTypes.HILLS.attributes());
        FabricDefaultAttributeRegistry.register(ModEntities.SAVANNAH_CREEPER, (class_5132.class_5133)CreeperTypes.SAVANNAH.attributes());
        FabricDefaultAttributeRegistry.register(ModEntities.MUSHROOM_CREEPER, (class_5132.class_5133)CreeperTypes.MUSHROOM.attributes());
        FabricDefaultAttributeRegistry.register(ModEntities.SWAMP_CREEPER, (class_5132.class_5133)CreeperTypes.SWAMP.attributes());
        FabricDefaultAttributeRegistry.register(ModEntities.DRIPSTONE_CREEPER, (class_5132.class_5133)CreeperTypes.DRIPSTONE.attributes());
        FabricDefaultAttributeRegistry.register(ModEntities.CAVE_CREEPER, (class_5132.class_5133)CreeperTypes.CAVE.attributes());
        FabricDefaultAttributeRegistry.register(ModEntities.DARK_OAK_CREEPER, (class_5132.class_5133)CreeperTypes.DARK_OAK.attributes());
        FabricDefaultAttributeRegistry.register(ModEntities.SPRUCE_CREEPER, (class_5132.class_5133)CreeperTypes.SPRUCE.attributes());
        FabricDefaultAttributeRegistry.register(ModEntities.BEACH_CREEPER, (class_5132.class_5133)CreeperTypes.BEACH.attributes());
        FabricDefaultAttributeRegistry.register(ModEntities.SNOWY_CREEPER, (class_5132.class_5133)CreeperTypes.SNOWY.attributes());
    }

    public void addSpawnRules() {
        SpawnRestrictionAccessor.callRegister(ModEntities.JUNGLE_CREEPER, (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13197, Creepers::checkMonsterSpawnRulesAbove);
        SpawnRestrictionAccessor.callRegister(ModEntities.BAMBOO_CREEPER, (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13197, Creepers::checkDayMonsterSpawnRulesAbove);
        SpawnRestrictionAccessor.callRegister(ModEntities.DESERT_CREEPER, (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, Creepers::checkMonsterSpawnRulesAbove);
        SpawnRestrictionAccessor.callRegister(ModEntities.BADLANDS_CREEPER, (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, Creepers::checkMonsterSpawnRulesAbove);
        SpawnRestrictionAccessor.callRegister(ModEntities.HILLS_CREEPER, (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, Creepers::checkMonsterSpawnRulesAbove);
        SpawnRestrictionAccessor.callRegister(ModEntities.SAVANNAH_CREEPER, (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, Creepers::checkMonsterSpawnRulesAbove);
        SpawnRestrictionAccessor.callRegister(ModEntities.MUSHROOM_CREEPER, (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, Creepers::checkDayMonsterSpawnRulesAbove);
        SpawnRestrictionAccessor.callRegister(ModEntities.SWAMP_CREEPER, (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, Creepers::checkMonsterSpawnRulesAbove);
        SpawnRestrictionAccessor.callRegister(ModEntities.DRIPSTONE_CREEPER, (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, Creepers::checkMonsterSpawnRulesCave);
        SpawnRestrictionAccessor.callRegister(ModEntities.CAVE_CREEPER, (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, Creepers::checkMonsterSpawnRulesCave);
        SpawnRestrictionAccessor.callRegister(ModEntities.DARK_OAK_CREEPER, (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, Creepers::checkMonsterSpawnRulesAbove);
        SpawnRestrictionAccessor.callRegister(ModEntities.SPRUCE_CREEPER, (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, Creepers::checkMonsterSpawnRulesAbove);
        SpawnRestrictionAccessor.callRegister(ModEntities.BEACH_CREEPER, (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, Creepers::checkMonsterSpawnRulesAbove);
        SpawnRestrictionAccessor.callRegister(ModEntities.SNOWY_CREEPER, (class_1317.class_1319)class_1317.class_1319.field_6317, (class_2902.class_2903)class_2902.class_2903.field_13203, Creepers::checkDayMonsterSpawnRulesAbove);
    }

    public void addCreepers() {
        this.addCreeper(BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9363}), ModEntities.BEACH_CREEPER);
        this.addCreeper(BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9363}), ModEntities.CAVE_CREEPER);
        this.addCreeper(BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9362}), ModEntities.SNOWY_CREEPER);
        this.addCreeper(BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9362}), ModEntities.CAVE_CREEPER);
        this.addCreeper(BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9368}), ModEntities.DESERT_CREEPER);
        this.addCreeper(BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9368}), ModEntities.CAVE_CREEPER);
        this.addCreeper(BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9357}), ModEntities.HILLS_CREEPER);
        this.addCreeper(BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9357}), ModEntities.CAVE_CREEPER);
        this.addCreeper(BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9356}), ModEntities.SAVANNAH_CREEPER);
        this.addCreeper(BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9356}), ModEntities.CAVE_CREEPER);
        this.addCreeper(BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9354}), ModEntities.BADLANDS_CREEPER);
        this.addCreeper(BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9354}), ModEntities.CAVE_CREEPER);
        BiomeModifications.addSpawn((Predicate)BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9365}), (class_1311)class_1311.field_6294, ModEntities.MUSHROOM_CREEPER, (int)10, (int)1, (int)2);
        this.addCreeper(BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9361}), ModEntities.SPRUCE_CREEPER);
        this.addCreeper(BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9361}), ModEntities.CAVE_CREEPER);
        this.addCreeper(BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_34464}).and(ctx -> ctx.getBiome().method_8694().equals((Object)class_1959.class_1963.field_9383)), ModEntities.SNOWY_CREEPER);
        this.addCreeper(BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_34464}).and(ctx -> !ctx.getBiome().method_8694().equals((Object)class_1959.class_1963.field_9383)), ModEntities.HILLS_CREEPER);
        this.addCreeper(BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_34464}), ModEntities.CAVE_CREEPER);
        this.addCreeper(BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_29217}), ModEntities.DRIPSTONE_CREEPER);
        this.addCreeper(BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_29217}), ModEntities.CAVE_CREEPER);
        this.addCreeper(BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9358}), ModEntities.BAMBOO_CREEPER);
        this.addCreeper(BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9358}), ModEntities.JUNGLE_CREEPER);
        this.addCreeper(BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9358}), ModEntities.CAVE_CREEPER);
        this.addCreeper(BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9364}), ModEntities.SWAMP_CREEPER);
        this.addCreeper(BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9364}), ModEntities.CAVE_CREEPER);
        this.addCreeper(BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_9475}), ModEntities.DARK_OAK_CREEPER);
        this.addCreeper(BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_9475}), ModEntities.CAVE_CREEPER);
    }

    public void removeCreepers() {
        Predicate<BiomeSelectionContext> creepersToRemove = BiomeSelectors.categories((class_1959.class_1961[])new class_1959.class_1961[]{class_1959.class_1961.field_9363, class_1959.class_1961.field_9362, class_1959.class_1961.field_9368, class_1959.class_1961.field_9357, class_1959.class_1961.field_9356, class_1959.class_1961.field_9354, class_1959.class_1961.field_9365, class_1959.class_1961.field_9361, class_1959.class_1961.field_34464, class_1959.class_1961.field_29217, class_1959.class_1961.field_9358, class_1959.class_1961.field_9364}).or(BiomeSelectors.includeByKey((class_5321[])new class_5321[]{class_1972.field_9475}));
        this.removeCreeper(creepersToRemove);
    }

    public static boolean checkMonsterSpawnRulesCave(class_1299<? extends class_1588> type, class_5425 world, class_3730 spawnReason, class_2338 pos, Random random) {
        return pos.method_10264() < world.method_8615() && !world.method_8320(pos.method_10074()).method_27852(class_2246.field_10219) && class_1588.method_20680(type, (class_5425)world, (class_3730)spawnReason, (class_2338)pos, (Random)random);
    }

    public static boolean checkMonsterSpawnRulesAbove(class_1299<? extends class_1588> type, class_5425 world, class_3730 spawnReason, class_2338 pos, Random random) {
        return pos.method_10264() > world.method_8615() && class_1588.method_20680(type, (class_5425)world, (class_3730)spawnReason, (class_2338)pos, (Random)random);
    }

    public static boolean checkDayMonsterSpawnRulesAbove(class_1299<? extends class_1588> type, class_5425 world, class_3730 spawnReason, class_2338 pos, Random random) {
        class_2680 state = world.method_8320(pos.method_10074());
        boolean isGrassLike = state.method_27852(class_2246.field_10219) || state.method_27852(class_2246.field_10520) || state.method_27852(class_2246.field_10402) || state.method_27852(class_2246.field_10566);
        return pos.method_10264() > world.method_8615() && class_1588.method_20681(type, (class_1936)world, (class_3730)spawnReason, (class_2338)pos, (Random)random) && (isGrassLike || state.method_26164(class_3481.field_25806) || state.method_26204() instanceof class_2397);
    }

    private <E extends BaseCreeper> void addCreeper(Predicate<BiomeSelectionContext> selectors, class_1299<E> entityType) {
        BiomeModifications.addSpawn(selectors, (class_1311)class_1311.field_6302, entityType, (int)75, (int)2, (int)2);
    }

    private void removeCreeper(Predicate<BiomeSelectionContext> biomeSelector) {
        class_2960 id = class_2378.field_11145.method_10221((Object)class_1299.field_6046);
        Preconditions.checkState((id != class_2378.field_11145.method_10137() ? 1 : 0) != 0, (String)"Unregistered entity type: %s", (Object)class_1299.field_6046);
        BiomeModifications.create((class_2960)id).add(ModificationPhase.REMOVALS, biomeSelector, context -> context.getSpawnSettings().removeSpawnsOfEntityType(class_1299.field_6046));
    }
}

